package furny.swing.admin.viewer;

import furny.entities.Furniture;

/**
 * Interface for the 3d model viewer.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public interface IModelViewer {

  /**
   * Sets the show grid flag.
   * 
   * @param show
   *          show grid
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract void setShowGrid(final boolean show);

  /**
   * Checks if is showing grid.
   * 
   * @return true, if is showing grid
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract boolean isShowGrid();

  /**
   * Checks if is rotating.
   * 
   * @return true, if is rotating
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract boolean isRotating();

  /**
   * Sets the rotating flag.
   * 
   * @param rotating
   *          the new rotating flag
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract void setRotating(final boolean rotating);

  /**
   * Sets the show statistics flag.
   * 
   * @param showStatistics
   *          the new show statistics flag
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract void setShowStatistics(final boolean showStatistics);

  /**
   * Checks if is showing statistics.
   * 
   * @return true, if is showing statistics
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract boolean isShowStatistics();

  /**
   * Method to set a furniture to view.
   * 
   * @param furn
   *          The furniture to view.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract void setFurniture(final Furniture furn);

  /**
   * Arrange the text.
   * 
   * @param width
   *          the width of the viewer.
   * @param height
   *          the height of the viewer.
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract void arrangeText(final int width, final int height);

  /**
   * Checks if is showing scale grid.
   * 
   * @return true, if is showing scale grid
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public boolean isShowScaleGrid();

  /**
   * Sets the show scale grid flag.
   * 
   * @param showScaleGrid
   *          the new show scale grid flag.
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void setShowScaleGrid(final boolean showScaleGrid);

  /**
   * Checks if is showing user scale grid.
   * 
   * @return true, if is showing user scale grid
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public boolean isShowUserScaleGrid();

  /**
   * Sets the show user scale grid flag.
   * 
   * @param showUserScaleGrid
   *          the new show user scale grid flag.
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void setShowUserScaleGrid(final boolean showUserScaleGrid);

  /**
   * Checks if is showing direction.
   * 
   * @return true, if is showing direction
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public boolean isShowDirection();

  /**
   * Sets the show direction flag.
   * 
   * @param showDirectionArrow
   *          the new show direction flag.
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void setShowDirection(final boolean showDirectionArrow);

  /**
   * Centers the furniture.
   * 
   * @param save
   *          Save the change if <code>true</code>.
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract void centerFurniture(boolean save);

  /**
   * Rotate furniture.
   * 
   * @param rotation
   *          the amount of rotation.
   * @param save
   *          Save the change if <code>true</code>.
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public abstract void rotateFurniture(final float rotation, final boolean save);

}
